/* General Multi-Site Selection Index Program */

libname dataV9 'd:\_DataSas\SpeciesDataSets';
libname outdir 'D:\NewData\ElecRec\_Monterrey';

/* Create dataset containing all pertinent tests */
data all; set dataV9.gmelina2005;
  
  if testid="470901A" or testid="470902C1" or testid="470905C1" or testid="470905C2";
  if prov=99 then prov=98;

  if testid="470901A" or testid="470902C1" then do;
   
    *delete;
    ht=ht8; dbh=dbh8; volume=volume8;
	st=st8; bd=bd8; fork=fork8; btop=btop8;

    if family=995 or family=996 then family=9995;
    if family=997 then family=9999;
	if family=998 then family=9995;
	if family=999 then family=9998;
	end;

  if testid="470905C1" or testid="470905C2" then do;
    ht=ht5; dbh=dbh5; volume=volume5;
	st=st5; bd=bd5; fork=fork5; 

    if family=998 or family=997 then family=9998;
    if family=996 then family=9996;
	if family=999 then family=9999;
	end;

  keep testid rep plot prov family tn 
     ht dbh volume st bd fork btop;

  if fill='X' then delete;
  *if prov ge 90 then delete;
run;
/* calculate CV */
proc sort data=all; by testid rep;
proc means noprint data=all; by testid rep;
var volume;
output out=repmns mean=repvol std=stdev;
data cv; set repmns;
cv=stdev/repvol;
proc means; run;

/* standardize data */
proc standard data=all out=all mean=100 std=47; by testid rep;
var volume;

/* family means */
proc sort data=all; by testid prov family;
proc means noprint data=all; by testid prov family;
var volume;
output out=fammns mean=famvol;

/* rep means */
proc sort data=all; by testid rep;
proc means noprint data=all; by testid rep;
var volume;
output out=repmns mean=repvol std=stdev;

/* test means */
proc sort data=all; by testid;
proc means noprint; by testid;
var volume; output out=testmns mean=testvol;


/* BLUP No testid*/
/*
proc mixed data=all; by testid; 
class testid rep prov family;
model volume = rep;
random prov family(prov) /s;
ods output covparms=parmvol;
ods output solutionr=hatvol;
run;
*/

/* BLUP Orig*/
proc mixed data=all; 
class testid rep prov family;
model volume = testid rep(testid);
random prov prov*testid family(prov) testid*family(prov)/s;
ods output covparms=parmvol;
ods output solutionr=hatvol;
run;

/* Clean up Hats */
data provhat gcahat; set hatvol;
if effect='Prov            ' then output provhat;
if effect='Family(Prov)       ' then output gcahat;
data provhat; set provhat; 
trait='vol';
provvol=estimate;
keep trait prov provvol;
proc sort; by prov;

data gcahat; set gcahat;
gcavol=estimate;
trait='vol';
keep trait prov family gcavol;
proc sort; by prov family;

data gcahat; merge gcahat provhat; by prov;
gainfam = provvol + gcavol;

proc rank data=gcahat descending out=gcahat; 
   var gainfam; ranks rankfam;
proc sort data=gcahat; by rankfam;
proc print;
var trait prov family provvol gcavol gainfam rankfam;
run;
proc means data=gcahat; run;

/* Clean up Parms */
data prov pxe fam fxe error; set parmvol;
if covparm='Prov               ' then output prov;
if covparm='testid*Prov        ' then output pxe;
if covparm='Family(Prov)       ' then output fam;
if covparm='testid*Family(Prov)' then output fxe;
if covparm='Residual           ' then output error;
run;

data prov; set prov; vp=estimate; drop estimate; keep vp;
data pxe; set pxe; vpxe=estimate; drop estimate; keep vpxe;
data fam; set fam; vf=estimate; drop estimate; keep vf;
data fxe; set fxe; vfxe=estimate; drop estimate; keep vfxe;
data error; set error; vr=estimate; drop estimate; keep vr;

/* no BY statement needed in this merge 
   since only one set of estimates */
data outdir.parms; merge prov pxe fam fxe error;  
trait='vol';
h2= 3*vf / (vf + vfxe + vr);
p2 = vp / (vf + vfxe + vr);
rbg = vf / (vf + vfxe);
rbp = vp / (vp + vpxe);
h2w = 2*vf / vr ;
run;

data parms; set outdir.parms;
 call symput('h2w', h2w);

/* Within family gain component */
data select; set all; 
proc sort data=select; by testid rep;
data select; merge select testmns; by testid;
data select; merge select repmns; by testid rep;
proc sort data=select; by testid prov family;
data select; merge select fammns; by testid prov family;
gainw = &h2w * (volume - repvol - famvol + testvol);
run;

proc sort data=select; by prov family;
data select; merge select provhat; by prov;
proc sort data=gcahat; by prov family;
data select; merge select gcahat; by prov family;
gaintree=gainfam + gainw;
proc means; run;

/* check defect distribution */
proc freq data=select;
tables st fork btop;
run;

/* delete defective trees */
data select; set select;
* if st=1 then delete;
* if fork='Y' then delete;
* if btop='Y' then delete;
if gaintree=. then delete;

/* get within-family ranks */
proc sort data=select; by prov family;
proc rank data=select descending out=select; by prov family;
   var gainw; ranks wfamrank;
/* Save select trees before weeding out */
data allselect; set select; run;
****************************************;
***** Start here to redo weeding out ***;
data select; set allselect; run;
/* select trees */
data select; set select;

if st=1 then factor=.5; else factor=1;

maxfam=6;
if prov= 14 then maxfam=40;
if prov=22 then maxfam=12; 

if prov= 13 or prov=15 or prov=2 or prov=3 then mingainw=1.0; else mingainw=1.3;
if (rankfam le 25 and wfamrank le maxfam*factor)
   or (rankfam le 50 and wfamrank le maxfam*.67*factor)
   or (rankfam le 70 and wfamrank le maxfam*.34*factor)
   or gainw ge mingainw;
run;

  

data outdir.select; set select;run;
/* check select distribution */
proc freq data=select;
tables testid prov;
run;

proc sort data=select; by descending gainfam;
proc print data=select; by descending gainfam;
var testid rep prov family plot tn ht dbh volume gainfam gainw gaintree wfamrank;
run;

data select; set select;
if testid="470901A" or testid="470902C1" then do;
   
    if family=9995 then family=9956;
    if family=9999 then family=997;
	if family=9995 then family=998;
	if family=9998 then family=999;
	end;

  if testid="470905C1" or testid="470905C2" then do;
  
    if family=9998 then family=9978;
    if family=9996 then family=996;
	if family=9999 then family=999;
	end;

  keep testid rep plot prov family tn ht dbh volume st bd fork btop
       famvol gainw provvol gcavol gainfam gaintree rankfam wfamrank;

run;
PROC EXPORT DATA= WORK.SELECT 
            OUTFILE= "D:\NewData\ElecRec\_Monterrey\MontGmelinaSelections.XLS" 
            DBMS=EXCEL REPLACE;
     SHEET="Selections"; 
RUN;

